/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.DBTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultDBTable
implements DBTable {
    protected String dbCatalogName;
    protected String dbSchemaName;
    protected String dbName;
    protected String adqlCatalogName = null;
    protected String adqlSchemaName = null;
    protected String adqlName = null;
    protected Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();

    public DefaultDBTable(String string) {
        this(string, null);
    }

    public DefaultDBTable(String string, String string2) {
        String[] stringArray = DefaultDBTable.splitTableName(string);
        if (stringArray[2] == null || stringArray[2].length() == 0) {
            throw new NullPointerException("Missing DB name !");
        }
        this.dbName = stringArray[2];
        this.dbSchemaName = stringArray[1];
        this.dbCatalogName = stringArray[0];
        stringArray = DefaultDBTable.splitTableName(string2);
        if (stringArray[2] == null || stringArray[2].length() == 0) {
            this.adqlName = this.dbName;
            this.adqlSchemaName = this.dbSchemaName;
            this.adqlCatalogName = this.dbCatalogName;
        } else {
            this.adqlName = stringArray[2];
            this.adqlSchemaName = stringArray[1];
            this.adqlCatalogName = stringArray[0];
        }
    }

    public DefaultDBTable(String string, String string2, String string3) {
        this(string, null, string2, null, string3, null);
    }

    public DefaultDBTable(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string5 == null || string5.length() == 0) {
            throw new NullPointerException("Missing DB name !");
        }
        this.dbName = string5;
        this.adqlName = string6;
        this.dbSchemaName = string3;
        this.adqlSchemaName = string4;
        this.dbCatalogName = string;
        this.adqlCatalogName = string2;
    }

    @Override
    public final String getDBName() {
        return this.dbName;
    }

    @Override
    public final String getDBSchemaName() {
        return this.dbSchemaName;
    }

    @Override
    public final String getDBCatalogName() {
        return this.dbCatalogName;
    }

    @Override
    public final String getADQLName() {
        return this.adqlName;
    }

    public void setADQLName(String string) {
        this.adqlName = string != null ? string : this.dbName;
    }

    @Override
    public final String getADQLSchemaName() {
        return this.adqlSchemaName;
    }

    public void setADQLSchemaName(String string) {
        this.adqlSchemaName = string != null ? string : this.dbSchemaName;
    }

    @Override
    public final String getADQLCatalogName() {
        return this.adqlCatalogName;
    }

    public void setADQLCatalogName(String string) {
        this.adqlName = string != null ? null : this.dbName;
    }

    @Override
    public DBColumn getColumn(String string, boolean bl) {
        if (bl) {
            return this.columns.get(string);
        }
        for (DBColumn dBColumn : this.columns.values()) {
            if (!dBColumn.getDBName().equals(string)) continue;
            return dBColumn;
        }
        return null;
    }

    public boolean hasColumn(String string, boolean bl) {
        return this.getColumn(string, bl) != null;
    }

    @Override
    public Iterator<DBColumn> iterator() {
        return this.columns.values().iterator();
    }

    public void addColumn(DBColumn dBColumn) {
        if (dBColumn != null) {
            this.columns.put(dBColumn.getADQLName(), dBColumn);
        }
    }

    public void addAllColumns(Collection<DBColumn> collection) {
        if (collection != null) {
            for (DBColumn dBColumn : collection) {
                this.addColumn(dBColumn);
            }
        }
    }

    public static final String[] splitTableName(String string) {
        String[] stringArray = new String[]{null, null, null};
        if (string == null || string.trim().length() == 0) {
            return stringArray;
        }
        String[] stringArray2 = string.trim().split("\\.");
        switch (stringArray2.length) {
            case 1: {
                stringArray[2] = string.trim();
                break;
            }
            case 2: {
                stringArray[2] = stringArray2[1].trim();
                stringArray[1] = stringArray2[0].trim();
                break;
            }
            case 3: {
                stringArray[2] = stringArray2[2].trim();
                stringArray[1] = stringArray2[1].trim();
                stringArray[0] = stringArray2[0].trim();
                break;
            }
            default: {
                stringArray[2] = stringArray2[stringArray2.length - 1].trim();
                stringArray[1] = stringArray2[stringArray2.length - 2].trim();
                StringBuffer stringBuffer = new StringBuffer(stringArray2[0].trim());
                for (int i = 1; i < stringArray2.length - 2; ++i) {
                    stringBuffer.append('.').append(stringArray2[i].trim());
                }
                stringArray[0] = stringBuffer.toString();
            }
        }
        return stringArray;
    }

    public static final String joinTableName(String[] stringArray) {
        int n;
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n2 = n = stringArray.length <= 3 ? 0 : stringArray.length - 3;
        while (n < stringArray.length) {
            String string;
            if (!bl) {
                stringBuffer.append('.');
            }
            String string2 = string = stringArray[n] == null ? null : stringArray[n].trim();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
                bl = false;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public DBTable copy(String string, String string2) {
        string = string == null ? DefaultDBTable.joinTableName(new String[]{this.dbCatalogName, this.dbSchemaName, this.dbName}) : string;
        string2 = string2 == null ? DefaultDBTable.joinTableName(new String[]{this.adqlCatalogName, this.adqlSchemaName, this.adqlName}) : string2;
        DefaultDBTable defaultDBTable = new DefaultDBTable(string, string2);
        for (DBColumn dBColumn : this) {
            if (dBColumn instanceof DBCommonColumn) {
                defaultDBTable.addColumn(new DBCommonColumn((DBCommonColumn)dBColumn, dBColumn.getDBName(), dBColumn.getADQLName()));
                continue;
            }
            defaultDBTable.addColumn(dBColumn.copy(dBColumn.getDBName(), dBColumn.getADQLName(), defaultDBTable));
        }
        return defaultDBTable;
    }
}

